clear all;
close all;

% Load .dat file
delimiterIn = ' ';
headerLinesIn = 0;
Data = importdata('Tsweeps_2_10K_Hparc.dat',delimiterIn,headerLinesIn);
Data = Data.data;

Data(:,4) = Data(:,4)./10000;

% Select temperature
n = size(Data,1);
H = 3;
k = 1;
l = 1;

for i = 1:n
    if (Data(i,4) >= (H-0.5)) && (Data(i,4) <= (H+0.5))
        Ch_one(l,k) = Data(i,3);
        Ch_one(l,k+1) = Data(i,7);
        Ch_two(l,k) = Data(i,3);
        Ch_two(l,k+1) = Data(i,27);
        l = l+1;
      else
        l = 1;
        
    end
end

n = size(Ch_one)./2;

for i = 1:n
    T1(i,1) = Ch_one(i*2-1,1);
    R1(i,1) = Ch_one(i*2-1,2);
    T2(i,1) = Ch_two(i*2,1);
    R2(i,1) = Ch_two(i*2,2);
end
       
Ch_one_final(:,1) = T1;
Ch_one_final(:,2) = R1;

Ch_two_final(:,1) = T2;
Ch_two_final(:,2) = R2;

save('T_Sweep_Para_c\FeSeLF8_3T.dat','Ch_one_final','-ascii');
save('T_Sweep_Para_c\FeSeLF9_3T.dat','Ch_two_final','-ascii');





    